package com.burhanstore.neonbubblequest.Utils.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.burhanstore.neonbubblequest.AppConst.PAYMENT_IMG_PTAH
import com.burhanstore.neonbubblequest.R
import com.burhanstore.neonbubblequest.Utils.model.PaymentModel


class AmountAdapter(
    private val items: List<PaymentModel>,
    private val py_currency: String,
    private val py_logo: String,
    private val py_title: String,
    private val onItemClick: (PaymentModel) -> Unit // click callback
) : RecyclerView.Adapter<AmountAdapter.PaymentViewHolder>() {

    inner class PaymentViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val coins: TextView = itemView.findViewById(R.id.coins)
        val value: TextView = itemView.findViewById(R.id.value)
        val ivLogo: ImageView = itemView.findViewById(R.id.imageView55)

        init {
            itemView.setOnClickListener {
                val position = adapterPosition
                if (position != RecyclerView.NO_POSITION) {
                    onItemClick(items[position])
                }
            }
        }


    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): PaymentViewHolder {
        val view = LayoutInflater.from(parent.context)
            .inflate(R.layout.amount_item, parent, false)
        return PaymentViewHolder(view)
    }

    override fun onBindViewHolder(holder: PaymentViewHolder, position: Int) {
        val item = items[position]


        holder.coins.text = item.py_rcoin
        holder.value.text = py_title + " " + item.py_amout + " " + py_currency


        item.py_logo.let {
            Glide.with(holder.itemView.context)
                .load(PAYMENT_IMG_PTAH + py_logo)
                .into(holder.ivLogo)
        }

    }

    override fun getItemCount(): Int = items.size
}
